/*******************************************************************************
********************************************************************************
** COPYRIGHT:      (c) 2011 Rohde & Schwarz, Munich
** MODULE:         10GSock.cpp
** ABBREVIATION:   
** COMPILER:       Visual Studio 2005
** LANGUAGE:       C/C++
** AUTHOR:         Christian Poessinger
** ABSTRACT:       10G Socket abstraction class with winpcap library
** PREMISES:       
** REMARKS:        This program is distributed in the hope that it will be useful,
                   but WITHOUT ANY WARRANTY
** HISTORY:        
**	2011-03-31: (poessing)	Creation
** REVIEW:         
********************************************************************************/

/* GLOBAL DEFINES ********************************************************/
#ifndef __10GSOCK_DEF
#define __10GSOCK_DEF

#define SIZE_ETHERNET       14      // ethernet header is always 14 byte
#define AMMOS_ZF_DATA_OFFS  18      // AMMOS-ZF frame starts at offset 18

#include "pcap.h"
#include "rs_gx40x_global_ifdata_header_if_defs.h"

using namespace std;

class C10GSock
{
public:
    C10GSock();
    ~C10GSock();

    virtual  int        CreateSocket( void );
    virtual  int        FindAndSelectInterface( void );

protected: // Helper methods
    virtual  void       ParseIFData( typIFD_IFDATA_FRAME_EX *data );

protected: // Members
    bpf_u_int32         m_Netmask;
    bpf_u_int32         m_IPAddress;
    pcap_t             *m_pHandle;
    pcap_if_t          *m_pCurDevice;
    pcap_if_t          *m_pAlldevs;

    int                 m_nNumDevices;
    double              m_lfRms;
    unsigned long       m_nMagicWordErr;
    unsigned long       m_nFrameLenErr;
    unsigned long       m_nFrameTypeErr;
    unsigned long       m_nDataHdrLenErr;
    unsigned long       m_nSigInval;
    unsigned long       m_nBlanking;
    unsigned long       m_nFramesLost;
    unsigned long       m_nCurCount;
    unsigned long       m_nTotalLen;
    unsigned long       m_oldtime;
    unsigned long long  m_nTotalCount;
    unsigned long long  m_nFrameCountOld;
};

#endif

/* GLOBAL VARIABLES **********************************************************/

/* GLOBAL CONSTANTS **********************************************************/

/* GLOBAL FUNCTIONS **********************************************************/